/*
 * Decompiled with CFR 0.152.
 */
package com.moulberry.axiom.render;

import com.mojang.blaze3d.systems.RenderSystem;
import com.moulberry.axiom.BiomeDataManager;
import com.moulberry.axiom.VersionUtils;
import com.moulberry.axiom.editor.EditorWindowType;
import com.moulberry.axiom.render.ShaderManager;
import com.moulberry.axiom.render.VertexConsumerProvider;
import com.moulberry.axiom.tools.Tool;
import com.moulberry.axiom.tools.ToolManager;
import com.moulberry.axiom.tools.biome_painter.BiomePainterTool;
import com.moulberry.axiom.utils.AxiomVertexFormats;
import com.moulberry.axiom.utils.FramebufferUtils;
import com.moulberry.axiom.utils.RenderHelper;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.longs.LongIterator;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import it.unimi.dsi.fastutil.longs.LongSet;
import net.minecraft.class_1923;
import net.minecraft.class_1959;
import net.minecraft.class_276;
import net.minecraft.class_2806;
import net.minecraft.class_2818;
import net.minecraft.class_287;
import net.minecraft.class_291;
import net.minecraft.class_293;
import net.minecraft.class_310;
import net.minecraft.class_4184;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_5253;
import net.minecraft.class_5321;
import net.minecraft.class_5944;
import net.minecraft.class_638;
import net.minecraft.class_6880;
import net.minecraft.class_7522;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.lwjgl.opengl.GL11;

public enum BiomeOverlayRenderer {
    INSTANCE;

    private final Long2ObjectMap<ChunkData> chunkDataMap = new Long2ObjectOpenHashMap();
    private LongSet tickDirtyChunkSet = new LongOpenHashSet();
    private LongSet forgetChunkSet = new LongOpenHashSet();
    private boolean clearChunkData = false;
    private class_276 renderTarget;
    private boolean active = false;

    public boolean isActive() {
        return this.active;
    }

    public void setActive(boolean active) {
        this.active = active;
    }

    public void render(class_4587 poseStack, Matrix4f projection, class_4184 camera) {
        Tool tool;
        class_638 level;
        if (this.clearChunkData) {
            this.clearChunkData = false;
            this.chunkDataMap.values().forEach(ChunkData::close);
            this.chunkDataMap.clear();
        }
        if ((level = class_310.method_1551().field_1687) == null) {
            return;
        }
        boolean biomeToolActive = false;
        if (ToolManager.isToolActive() && (tool = ToolManager.getCurrentTool()) instanceof BiomePainterTool) {
            BiomePainterTool biomePainterTool = (BiomePainterTool)tool;
            biomeToolActive = biomePainterTool.shouldRenderBiomeOverlay();
        }
        if (!(this.active || EditorWindowType.SET_BIOME.isOpenAndActive() || biomeToolActive)) {
            return;
        }
        class_5944 shader = ShaderManager.borderShader;
        if (shader == null) {
            return;
        }
        this.uploadDirty();
        RenderSystem.enableDepthTest();
        RenderSystem.enableCull();
        GL11.glCullFace((int)1029);
        RenderSystem.enableBlend();
        RenderSystem.blendFuncSeparate((int)1, (int)0, (int)1, (int)0);
        float offsetY = level.method_31607();
        int mainWidth = class_310.method_1551().method_1522().field_1482;
        int mainHeight = class_310.method_1551().method_1522().field_1481;
        this.renderTarget = FramebufferUtils.resizeOrCreateFramebuffer(this.renderTarget, mainWidth, mainHeight);
        this.renderTarget.method_1230(class_310.field_1703);
        this.renderTarget.method_29329(class_310.method_1551().method_1522());
        this.renderTarget.method_1235(true);
        poseStack.method_22903();
        poseStack.method_22904(-camera.method_19326().field_1352, -camera.method_19326().field_1351, -camera.method_19326().field_1350);
        Matrix4f modelViewMatrix = poseStack.method_23760().method_23761();
        RenderHelper.setupShader(shader, modelViewMatrix, projection);
        Matrix4f translatedMatrix = new Matrix4f();
        for (ChunkData chunkData : this.chunkDataMap.values()) {
            if (shader.field_29470 != null) {
                translatedMatrix.set((Matrix4fc)modelViewMatrix);
                translatedMatrix.translate((float)chunkData.offsetX, offsetY, (float)chunkData.offsetZ);
                shader.field_29470.method_1250(translatedMatrix);
                shader.field_29470.method_1300();
            }
            class_291 buffer = chunkData.vertexBuffer;
            buffer.method_1353();
            buffer.method_35665();
        }
        RenderHelper.finishShader(shader);
        class_291.method_1354();
        poseStack.method_22909();
        RenderSystem.defaultBlendFunc();
        class_310.method_1551().method_1522().method_1235(true);
        FramebufferUtils.blitToScreenBlend(this.renderTarget, mainWidth, mainHeight);
    }

    public void uploadDirty() {
        class_638 level = class_310.method_1551().field_1687;
        if (level == null) {
            return;
        }
        if (!this.forgetChunkSet.isEmpty()) {
            LongSet forgetChunkSet = this.forgetChunkSet;
            LongIterator longIterator = forgetChunkSet.longIterator();
            while (longIterator.hasNext()) {
                long pos = longIterator.nextLong();
                ChunkData data = (ChunkData)this.chunkDataMap.remove(pos);
                if (data == null) continue;
                data.close();
            }
            this.forgetChunkSet = new LongOpenHashSet();
        }
        if (this.tickDirtyChunkSet.isEmpty()) {
            return;
        }
        LongSet dirtyChunkSet = this.tickDirtyChunkSet;
        this.tickDirtyChunkSet = new LongOpenHashSet();
        BiomeDataManager biomeDataManager = BiomeDataManager.get();
        LongIterator longIterator = dirtyChunkSet.longIterator();
        while (longIterator.hasNext()) {
            int chunkZ;
            long pos = longIterator.nextLong();
            int chunkX = class_1923.method_8325((long)pos);
            class_2818 chunk = (class_2818)level.method_8402(chunkX, chunkZ = class_1923.method_8332((long)pos), class_2806.field_12803, false);
            if (chunk == null) continue;
            ChunkData chunkData = (ChunkData)this.chunkDataMap.get(pos);
            if (chunkData == null) {
                chunkData = new ChunkData(chunkX * 16, chunkZ * 16);
                this.chunkDataMap.put(pos, (Object)chunkData);
            }
            if (chunkData.vertexBuffer == null) {
                chunkData.vertexBuffer = new class_291(class_291.class_8555.field_44793);
            }
            VertexConsumerProvider provider = VertexConsumerProvider.shared();
            BiomeOverlayRenderer.renderChunk(biomeDataManager, level, chunk, chunkX, chunkZ, provider);
            chunkData.vertexBuffer.method_1353();
            chunkData.vertexBuffer.method_1352(provider.build());
        }
        class_291.method_1354();
    }

    private static void renderChunk(BiomeDataManager biomeDataManager, class_638 level, class_2818 chunk, int chunkX, int chunkZ, VertexConsumerProvider provider) {
        class_287 bufferBuilder = provider.begin(class_293.class_5596.field_27382, AxiomVertexFormats.BORDER_VERTEX_FORMAT);
        int alpha = 160;
        int minSection = chunk.method_32891();
        int maxSection = chunk.method_31597();
        class_2818 northChunk = (class_2818)level.method_8402(chunkX, chunkZ - 1, class_2806.field_12803, false);
        class_2818 westChunk = (class_2818)level.method_8402(chunkX - 1, chunkZ, class_2806.field_12803, false);
        class_7522 aboveSection = chunk.method_38259(0).method_38294();
        for (int sectionY = minSection; sectionY < maxSection; ++sectionY) {
            class_7522 section = aboveSection;
            aboveSection = sectionY == maxSection - 1 ? null : chunk.method_38259(sectionY - minSection + 1).method_38294();
            class_7522 northSection = northChunk == null ? null : northChunk.method_38259(sectionY - minSection).method_38294();
            class_7522 westSection = westChunk == null ? null : westChunk.method_38259(sectionY - minSection).method_38294();
            int offsetY = (sectionY - minSection) * 16;
            for (int x = 0; x < 16; x += 4) {
                for (int y = 0; y < 16; y += 4) {
                    for (int z = 0; z < 16; z += 4) {
                        class_6880.class_6883 westBiome;
                        class_6880.class_6883 northBiome;
                        int bx = x >> 2;
                        int by = y >> 2;
                        int bz = z >> 2;
                        class_6880.class_6883 biome = (class_6880.class_6883)section.method_12321(bx, by, bz);
                        int argb = biomeDataManager.getData((class_5321<class_1959>)biome.method_40237()).colour();
                        int red = class_5253.class_5254.method_27765((int)argb);
                        int green = class_5253.class_5254.method_27766((int)argb);
                        int blue = class_5253.class_5254.method_27767((int)argb);
                        class_6880.class_6883 aboveBiome = by == 3 ? (aboveSection == null ? null : (class_6880.class_6883)aboveSection.method_12321(bx, 0, bz)) : (class_6880.class_6883)section.method_12321(bx, by + 1, bz);
                        if (biome != aboveBiome) {
                            VersionUtils.helperOldAddVertex((class_4588)bufferBuilder, x, offsetY + y + 4, z).method_1336(red, green, blue, alpha).method_22921(0, 0);
                            VersionUtils.helperOldAddVertex((class_4588)bufferBuilder, x, offsetY + y + 4, z + 4).method_1336(red, green, blue, alpha).method_22921(0, 1);
                            VersionUtils.helperOldAddVertex((class_4588)bufferBuilder, x + 4, offsetY + y + 4, z + 4).method_1336(red, green, blue, alpha).method_22921(1, 1);
                            VersionUtils.helperOldAddVertex((class_4588)bufferBuilder, x + 4, offsetY + y + 4, z).method_1336(red, green, blue, alpha).method_22921(1, 0);
                            if (aboveBiome != null) {
                                int invArgb = biomeDataManager.getData((class_5321<class_1959>)aboveBiome.method_40237()).colour();
                                int invRed = class_5253.class_5254.method_27765((int)invArgb);
                                int invGreen = class_5253.class_5254.method_27766((int)invArgb);
                                int invBlue = class_5253.class_5254.method_27767((int)invArgb);
                                VersionUtils.helperOldAddVertex((class_4588)bufferBuilder, x + 4, offsetY + y + 4, z).method_1336(invRed, invGreen, invBlue, alpha).method_22921(1, 0);
                                VersionUtils.helperOldAddVertex((class_4588)bufferBuilder, x + 4, offsetY + y + 4, z + 4).method_1336(invRed, invGreen, invBlue, alpha).method_22921(1, 1);
                                VersionUtils.helperOldAddVertex((class_4588)bufferBuilder, x, offsetY + y + 4, z + 4).method_1336(invRed, invGreen, invBlue, alpha).method_22921(0, 1);
                                VersionUtils.helperOldAddVertex((class_4588)bufferBuilder, x, offsetY + y + 4, z).method_1336(invRed, invGreen, invBlue, alpha).method_22921(0, 0);
                            }
                        }
                        if ((northBiome = bz == 0 ? (northSection == null ? null : (class_6880.class_6883)northSection.method_12321(bx, by, 3)) : (class_6880.class_6883)section.method_12321(bx, by, bz - 1)) != null && biome != northBiome) {
                            VersionUtils.helperOldAddVertex((class_4588)bufferBuilder, x, offsetY + y + 4, z).method_1336(red, green, blue, alpha).method_22921(1, 0);
                            VersionUtils.helperOldAddVertex((class_4588)bufferBuilder, x + 4, offsetY + y + 4, z).method_1336(red, green, blue, alpha).method_22921(1, 1);
                            VersionUtils.helperOldAddVertex((class_4588)bufferBuilder, x + 4, offsetY + y, z).method_1336(red, green, blue, alpha).method_22921(0, 1);
                            VersionUtils.helperOldAddVertex((class_4588)bufferBuilder, x, offsetY + y, z).method_1336(red, green, blue, alpha).method_22921(0, 0);
                            int invArgb = biomeDataManager.getData((class_5321<class_1959>)northBiome.method_40237()).colour();
                            int invRed = class_5253.class_5254.method_27765((int)invArgb);
                            int invGreen = class_5253.class_5254.method_27766((int)invArgb);
                            int invBlue = class_5253.class_5254.method_27767((int)invArgb);
                            VersionUtils.helperOldAddVertex((class_4588)bufferBuilder, x, offsetY + y, z).method_1336(invRed, invGreen, invBlue, alpha).method_22921(0, 0);
                            VersionUtils.helperOldAddVertex((class_4588)bufferBuilder, x + 4, offsetY + y, z).method_1336(invRed, invGreen, invBlue, alpha).method_22921(0, 1);
                            VersionUtils.helperOldAddVertex((class_4588)bufferBuilder, x + 4, offsetY + y + 4, z).method_1336(invRed, invGreen, invBlue, alpha).method_22921(1, 1);
                            VersionUtils.helperOldAddVertex((class_4588)bufferBuilder, x, offsetY + y + 4, z).method_1336(invRed, invGreen, invBlue, alpha).method_22921(1, 0);
                        }
                        if ((westBiome = bx == 0 ? (westSection == null ? null : (class_6880.class_6883)westSection.method_12321(3, by, bz)) : (class_6880.class_6883)section.method_12321(bx - 1, by, bz)) != null && biome != westBiome) {
                            VersionUtils.helperOldAddVertex((class_4588)bufferBuilder, x, offsetY + y, z).method_1336(red, green, blue, alpha).method_22921(0, 0);
                            VersionUtils.helperOldAddVertex((class_4588)bufferBuilder, x, offsetY + y, z + 4).method_1336(red, green, blue, alpha).method_22921(0, 1);
                            VersionUtils.helperOldAddVertex((class_4588)bufferBuilder, x, offsetY + y + 4, z + 4).method_1336(red, green, blue, alpha).method_22921(1, 1);
                            VersionUtils.helperOldAddVertex((class_4588)bufferBuilder, x, offsetY + y + 4, z).method_1336(red, green, blue, alpha).method_22921(1, 0);
                            int invArgb = biomeDataManager.getData((class_5321<class_1959>)westBiome.method_40237()).colour();
                            int invRed = class_5253.class_5254.method_27765((int)invArgb);
                            int invGreen = class_5253.class_5254.method_27766((int)invArgb);
                            int invBlue = class_5253.class_5254.method_27767((int)invArgb);
                            VersionUtils.helperOldAddVertex((class_4588)bufferBuilder, x, offsetY + y + 4, z).method_1336(invRed, invGreen, invBlue, alpha).method_22921(1, 0);
                            VersionUtils.helperOldAddVertex((class_4588)bufferBuilder, x, offsetY + y + 4, z + 4).method_1336(invRed, invGreen, invBlue, alpha).method_22921(1, 1);
                            VersionUtils.helperOldAddVertex((class_4588)bufferBuilder, x, offsetY + y, z + 4).method_1336(invRed, invGreen, invBlue, alpha).method_22921(0, 1);
                            VersionUtils.helperOldAddVertex((class_4588)bufferBuilder, x, offsetY + y, z).method_1336(invRed, invGreen, invBlue, alpha).method_22921(0, 0);
                        }
                        if (by != 0 || sectionY != minSection) continue;
                        VersionUtils.helperOldAddVertex((class_4588)bufferBuilder, x + 4, offsetY + y, z).method_1336(red, green, blue, alpha).method_22921(1, 0);
                        VersionUtils.helperOldAddVertex((class_4588)bufferBuilder, x + 4, offsetY + y, z + 4).method_1336(red, green, blue, alpha).method_22921(1, 1);
                        VersionUtils.helperOldAddVertex((class_4588)bufferBuilder, x, offsetY + y, z + 4).method_1336(red, green, blue, alpha).method_22921(0, 1);
                        VersionUtils.helperOldAddVertex((class_4588)bufferBuilder, x, offsetY + y, z).method_1336(red, green, blue, alpha).method_22921(0, 0);
                    }
                }
            }
        }
    }

    public void clear() {
        this.tickDirtyChunkSet.clear();
        this.forgetChunkSet.clear();
        this.clearChunkData = true;
    }

    public void markDirty(int chunkX, int chunkZ) {
        long pos = class_1923.method_8331((int)chunkX, (int)chunkZ);
        this.tickDirtyChunkSet.add(pos);
    }

    public void forgetChunk(int chunkX, int chunkZ) {
        long pos = class_1923.method_8331((int)chunkX, (int)chunkZ);
        this.forgetChunkSet.add(pos);
        this.tickDirtyChunkSet.remove(pos);
    }

    private static class ChunkData {
        private class_291 vertexBuffer = new class_291(class_291.class_8555.field_44793);
        private final int offsetX;
        private final int offsetZ;

        public ChunkData(int offsetX, int offsetZ) {
            this.offsetX = offsetX;
            this.offsetZ = offsetZ;
        }

        public void close() {
            this.vertexBuffer.close();
            this.vertexBuffer = null;
        }
    }
}

